/*****  Packages  *****/
import cors from "cors";
import express from "express"
import winston from "winston";
import BodyParser from "body-parser";
import cron from 'node-cron';

/*****  Modules  *****/
import connectDB from "#config/db";
import logger from "#utils/logger";
import { handleReferral } from "#utils/referral";
import routes from "#routes/index";
import { envConfig } from "#utils/env";
import cookieParser from "cookie-parser";
import { Telegraf } from 'telegraf'
import { message } from 'telegraf/filters'
import { UserWallet } from "#models/user_wallet_model"
import  crypto  from "crypto";

envConfig();
connectDB();
logger();

const app = express();
const PORT = process.env.PORT || 5000;
export const bot = new Telegraf('7549061925:AAH36xglGl-k-LGBJMl0R8fDsPcPvBimXjU');

/*****  Middlewares  *****/
app.use(cors({ origin: true, credentials: true }));

app.use(cookieParser());
app.use(express.json())
app.use(BodyParser.urlencoded({ extended: false }));
app.use('/uploads', express.static('uploads'));
routes(app, bot);

// Twitter OAuth 2.0 credentials
const CLIENT_ID = process.env.TWITTER_CLIENT_ID;
const CLIENT_SECRET = process.env.TWITTER_CLIENT_SECRET;
const CALLBACK_URL = process.env.TWITTER_CALLBACK_URL;

bot.start((ctx) => {
    const args = ctx.message.text.split(' ');
    console.log(args, "argsargsargs");

    // Check if the user came with a referral code
    if (args.length > 1 && args[1].startsWith('r_')) {
        const referralCode = args[1];
        const referrerId = referralCode.split('_')[1];
        console.log(referrerId);
        // Store the referral information (uncomment if you have a function)
        // handleReferral(ctx.from.id, referrerId);
        UserWallet.findOne({ userTelId: referrerId })
            .then((user) => {
                if (user) {
                    // Extract the userName field from the found document
                    const referralName = user.userName;
                    console.log('Referral Name:', referralName);
                    // Reply to the user with the referral information
                    ctx.reply(`🎉 Hooray! You've been warmly welcomed by your referrer, ${referralName}! 🎈\nLet's get started and explore the awesome features we have for you! 🚀`);
                    startMiniApp(ctx, referrerId);
                } else {
                    console.log('No user found with the provided referrer ID');
                }
            })
            .catch((error) => {
                console.error('Error fetching referral name:', error);
            });

    } else {
        // User came without a referral code
        // const welcomeMessage = "Welcome to TaskRewardGameBot! Get started by exploring our tasks and earn rewards.";
        const welcomeMessage = "🎉 Welcome to DogTradeBot! 🌟 Start exploring exciting tasks and earn amazing rewards! 💰✨";
        // Send a GIF along with the welcome message and option to start the Mini App
        // const gifUrl = 'https://wild.solutions/wp-content/uploads/2023/07/V4_LOW_ALPHA.gif'; // Replace with your GIF URL
        const gifUrl = 'https://testserver.javatimescaffe.com/uploads/Welcome5.jpg'; // Replace with your GIF URL
        const miniAppUrl = `https://testing.pluton.ltd`;
        // const joinCommunityUrl = `https://t.me/+_a5_1mzovXY1Y2Zk`; // Replace with actual URL
        const joinCommunityUrl = `https://t.me/myBotDog`; // Replace with actual URL
        const aboutUsUrl = `https://testing.pluton.ltd`; // Replace with actual URL

        ctx.replyWithPhoto(gifUrl, {
            caption: welcomeMessage,
            reply_markup: {
                inline_keyboard: [
                    [
                        {
                            text: 'Open Mini App',
                            web_app: { url: miniAppUrl }
                        }
                    ],
                    [
                        {
                            text: 'Join Community',
                            url: joinCommunityUrl
                        }
                    ],
                    [
                        {
                            text: 'About Us',
                            web_app: { url: aboutUsUrl }
                        }
                    ]
                ]
            }
        });
    }
})

async function startMiniApp(ctx, referrerId) {
    const userId = ctx.from.id; // User ID
    const gifUrl = 'https://testserver.javatimescaffe.com/uploads/Welcome5.jpg';

    
   // Make sure to await the findOne call to resolve the promise
   let isUserFound = await UserWallet.findOne({ userTelId: userId });
    
    let miniAppUrl;

    console.log(isUserFound,"isUserFoundisUserFound");

    if(!isUserFound){
        // miniAppUrl = `https://testing.pluton.ltd/?referrer_id=${referrerId}&user_id=${userId}`;
        miniAppUrl = `https://9a0a-2607-6b80-6-0-d903-a5ce-d664-dcaa.ngrok-free.app/?referrer_id=${referrerId}&user_id=${userId}`;
    } else {
        miniAppUrl = `https://testing.pluton.ltd/`;
    }
    
    // const twitterUrl =`https://x.com/Cristiano?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Eauthor`
    // Generate a code verifier and challenge for PKCE
   const codeVerifier = crypto.randomBytes(32).toString('hex'); // random string
   const codeChallenge = generateCodeChallenge(codeVerifier);

    // Store the codeVerifier in the session for later use
    // req.session.codeVerifier = codeVerifier;

    console.log(CLIENT_SECRET, CALLBACK_URL ,"codeChallengecodeChallenge");
    console.log(codeChallenge, "codeChallenge");
    
    // Redirect to Twitter OAuth with proper encoding and code challenge
    // const twitterUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${encodeURIComponent(CLIENT_ID)}&redirect_uri=${encodeURIComponent(CALLBACK_URL)}&scope=${encodeURIComponent('users.read+tweet.read')}&state=${userId}&code_challenge=${codeChallenge}&code_challenge_method=S256`;
    const twitterUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${CLIENT_ID}&redirect_uri=${CALLBACK_URL}&scope=tweet.read+users.read&state=${userId}&code_challenge=challenge&code_challenge_method=plain`;
    const joinCommunityUrl = `https://t.me/myBotDog`;
    // ctx.reply('Click the button below to start the Mini App:', {
    //     reply_markup: {
    //         inline_keyboard: [
    //             [
    //                 {
    //                     text: 'Open Mini App',
    //                     web_app: { url: miniAppUrl }
    //                 }
    //             ],
    //             [
    //                 {
    //                     text: 'Join Community',
    //                     url: joinCommunityUrl
    //                 }
    //             ],
    //             [
    //                 {
    //                     text: 'X DogT ',
    //                     web_app: { url: twitterUrl }
    //                 }
    //             ]
    //         ]
    //     }
    // });

    
    ctx.replyWithPhoto(gifUrl, {
        caption: 'Click the button below to start the Mini App:',
        reply_markup: {
            inline_keyboard: [
                [
                    {
                        text: 'Open Mini App',
                        web_app: { url: miniAppUrl }
                    }
                ],
                [
                    {
                        text: 'Join Community',
                        url: joinCommunityUrl
                    }
                ],
                [
                    {
                        text: 'Join X',
                        url: twitterUrl 
                    }
                ]
            ]
        }
    });

    // ctx.reply(link("Launch", `https://t.me/$TaskRewardGameBot/$game_bot?startapp=$command?referrer_id=${referrerId}&user_id=${ctx.from.id}`));
    // ctx.reply(link("Launch", miniAppUrl));
}

// bot.command("link", ctx =>
// 	/*
// 		Go to @Botfather and create a new app for your bot first, using /newapp
// 		Then modify this link appropriately.

// 		startapp is optional.
// 		If provided, it will be passed as start_param in initData
// 		and as ?tgWebAppStartParam=$command in the Web App URL
// 	*/
// 	ctx.reply(link("Launch", "https://3b82-2400-adc1-179-c600-de6-ecfd-69d2-10d2.ngrok-free.app/?referrer_id=${referrerId}&user_id=${userId}")),
// );


// sendTelegramNotification("","welcome to Telegram");

cron.schedule('0 9 * * *', () => {
    sendReminderToInactiveUsers(bot); // Sends notifications daily at 9:00 AM
});

cron.schedule('0 * * * *', () => { // Runs every hour
    sendClaimNotification(bot);
});

bot.launch();

/////////////////////////// APISSSSSSSSSSSSS /////////////////////////////////////////////////////

import passport from 'passport';
import { Strategy as TwitterStrategy } from 'passport-twitter';
import session from 'express-session';
import axios from 'axios';
import cookieSession from 'cookie-session';
import { sendClaimNotification, sendReminderToInactiveUsers, sendTelegramNotification } from "#utils/telegramNotification";
import { Referral } from "#models/referral_model";

// Setup cookie session
app.use(
    cookieSession({
        maxAge: 24 * 60 * 60 * 1000, // 1 day
        keys: [process.env.COOKIE_KEY],
    })
);



// // Redirect user to Twitter for authentication
// app.get('/auth/twitter', (req, res) => {
//     const twitterAuthUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${CLIENT_ID}&redirect_uri=${CALLBACK_URL}&scope=tweet.read%20users.read%20offline.access&state=state&code_challenge=challenge&code_challenge_method=plain`;
//     res.redirect(twitterAuthUrl);
// });


// Utility function to generate a code challenge for PKCE
const generateCodeChallenge = (codeVerifier) => {
    return crypto.createHash('sha256').update(codeVerifier).digest('base64url');
};


// app.get('/auth/twitter', (req, res) => {
//     const { telegramId } = req.query;

//     if (!telegramId) {
//         return res.status(400).send('Telegram ID is required');
//     }

//     // Save the Telegram ID to the session (or store it elsewhere as needed)
//     state = telegramId;

//     // Generate a code verifier and challenge for PKCE
//     const codeVerifier = crypto.randomBytes(32).toString('hex'); // random string
//     const codeChallenge = generateCodeChallenge(codeVerifier);

//     // Store the codeVerifier in the session for later use
//     req.session.codeVerifier = codeVerifier;

//     // Redirect to Twitter OAuth with proper encoding and code challenge
//     const twitterAuthUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${encodeURIComponent(CLIENT_ID)}&redirect_uri=${encodeURIComponent(CALLBACK_URL)}&scope=${encodeURIComponent('tweet.read users.read offline.access')}&state=state&code_challenge=${codeChallenge}&code_challenge_method=S256`;

//     console.log("Doneeeeeeeeeee");
//     res.redirect(twitterAuthUrl);
// });


// // Start Twitter OAuth process and pass Telegram ID
app.get('/auth/twitter', (req, res) => {
    const { telegramId } = req.query;

    if (!telegramId) {
        return res.status(400).send('Telegram ID is required');
    }

    // Save the telegramId to the session
    state = telegramId;

    // Redirect to Twitter OAuth
    // const twitterAuthUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${CLIENT_ID}&redirect_uri=${CALLBACK_URL}&scope=tweet.read%20users.read%20offline.access&state=state&code_challenge=challenge&code_challenge_method=plain`;
    const twitterAuthUrl = `https://twitter.com/i/oauth2/authorize?response_type=code&client_id=${CLIENT_ID}&redirect_uri=${CALLBACK_URL}&scope=tweet.read+users.read&state=${telegramId}&code_challenge=challenge&code_challenge_method=plain`;
    console.log("DOneeeeeeeeee");
    res.redirect(twitterAuthUrl);
});


// Handle callback and exchange code for tokens
app.get('/auth/twitter/callback', async (req, res) => {
    const { code, state } = req.query; // Extract code and state (telegramId)

    try {
        const response = await axios.post(
            'https://api.twitter.com/2/oauth2/token',
            {
                code,
                grant_type: 'authorization_code',
                client_id: CLIENT_ID,
                redirect_uri: CALLBACK_URL,
                code_verifier: 'challenge',
            },
            {
                auth: {
                    username: CLIENT_ID,
                    password: CLIENT_SECRET,
                },
            }
        );

        const { access_token } = response.data;

        // Store access token in session
        req.session.accessToken = access_token;
        
        console.log(access_token,"access_token");

        // Fetch user profile to get Twitter user ID
        const profileResponse = await axios.get('https://api.twitter.com/2/users/me', {
            headers: {
                Authorization: `Bearer ${access_token}`,
            },
        });

        console.log(profileResponse.data,"profileResponse.data");

        const twitterUserId = profileResponse.data.id;

        // Check if telegramId exists in session
        if (!state) {
            throw new Error('Telegram ID not found in session');
        }

        console.log(state,"statestatestate");

        const userDetails = await UserWallet.findOne({ userTelId: state});
        // Find referral information
          const referral = await Referral.findOne({ referred_user: userDetails?._id });
         // Check if referral exists and has referring_by field
          if (referral && referral.referring_by) {
              const referrerRewardAmount = userDetails.isPremiumUser ? 20 * 0.08 : 20 * 0.04; //Twitter reward
              const referral_by = await UserWallet.findById({ _id: referral.referring_by });
              
              if (referral_by) {
                  referral_by.userBalance += referrerRewardAmount;
                  await referral_by.save();
                  console.log("Referral bonus added to referrer.");
              } else {
                  console.log("Referrer not found.");
              }
          }

          //userDetails.userBalance += 20;
          userDetails.isTwitterConnected = true;
        //   userDetails.userLevels += 1;
          await userDetails.save()
        
        console.log("redirectComplete");

        // Redirect to your Telegram bot with the user’s Telegram ID in the URL
        res.redirect(`https://testing.pluton.ltd/close`);
        // res.redirect(`https://x.com`);
    } catch (error) {
        console.error('Error exchanging code for tokens:', error.response?.data || error.message);
        res.status(500).send('Authentication failed');
    }
});


// // Handle callback and exchange code for tokens
// app.get('/auth/twitter/callback', async (req, res) => {
//     const { code, state} = req.query; // Extract authorization code and state (which holds telegramId)

//     try {
//         // // Retrieve the code_verifier from the session storage (or other persistent storage)
//         // const codeVerifier = req.query.codeVerifier;

//         // if (!codeVerifier) {
//         //     throw new Error('Code verifier not found in session');
//         // }

//         // Exchange authorization code for access tokens using PKCE
//         const response = await axios.post(
//             'https://api.twitter.com/2/oauth2/token',
//             {
//                 code,
//                 grant_type: 'authorization_code',
//                 client_id: CLIENT_ID,
//                 redirect_uri: CALLBACK_URL,
//                 code_verifier: 'challenge',
//                 //code_verifier: codeVerifier,  // Send the correct code verifier
//             },
//             {
//                 auth: {
//                     username: CLIENT_ID,
//                     password: CLIENT_SECRET,
//                 },
//             }
//         );

//         const { access_token } = response.data;

//         // Log access token for debugging purposes (you should remove this in production)
//         console.log('Access token:', access_token);

//         // Fetch user profile from Twitter API to get Twitter user ID
//         const profileResponse = await axios.get('https://api.twitter.com/2/users/me', {
//             headers: {
//                 Authorization: `Bearer ${access_token}`,
//             },
//         });

//         console.log('Twitter User Profile:', profileResponse.data);

//         const twitterUserId = profileResponse.data.id;

//         // Check if Telegram ID (state) exists
//         if (!state) {
//             throw new Error('Telegram ID not found in query state');
//         }

//         console.log('Telegram ID (state):', state);

//         // Find the user in your database using the Telegram ID (state)
//         const userDetails = await UserWallet.findOne({ userTelId: state });

//         if (!userDetails) {
//             throw new Error('User not found');
//         }

//         // Check if referral exists
//         const referral = await Referral.findOne({ referred_user: userDetails._id });

//         // If referral exists, calculate referrer reward
//         if (referral && referral.referring_by) {
//             const referrerRewardAmount = userDetails.isPremiumUser ? 20 * 0.08 : 20 * 0.04; // Twitter reward
//             const referrer = await UserWallet.findById(referral.referring_by);

//             if (referrer) {
//                 referrer.userBalance += referrerRewardAmount;
//                 await referrer.save();
//                 console.log('Referral bonus added to referrer.');
//             } else {
//                 console.log('Referrer not found.');
//             }
//         }

//         // Update user to mark Twitter as connected
//         userDetails.isTwitterConnected = true;
//         await userDetails.save();

//         console.log('User profile updated, Twitter connected.');
        
//         // Redirect to your Telegram bot or close the OAuth window
//         // res.redirect(`https://f832-2605-6440-4011-a000-f18-a04b-1b4f-3b80.ngrok-free.app/close`);
//         res.redirect(`https://x.com`);
//     } catch (error) {
//         console.error('Error during token exchange or user update:', error.response?.data || error.message);
//         res.status(500).send('Authentication failed');
//     }
// });

// Logout and clear session
app.get('/logout', (req, res) => {
    req.session = null;
    res.redirect('/');
});
app.get('/kashan', (req, res) => {
  
   return res.json('kashan');
});

app.listen(PORT, () => winston.info(`Server is Listening on port ${PORT}.`));
